function m_full = get_full_mask(m,frame_d)
% Convert frame rate mask to a sample-by-sample mask
% 
%   m_full = get_full_mask(m,frame_d)
% 
%   m_full = get_full_mask(m,frame_d) expands the binary
%   mask m, which has one unit for each frequency channel
%   and frame of length frame_d. The transitions between
%   units of different values are softened with a raised
%   cosine. It is assumed that the mask has dimensions
%   [frequency,time].
% 
%   See also RESYNTHESISE.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

numchans = size(m,1);
frameCount = size(m,2);

window_single = (0.5.*cos(linspace(-pi,pi,frame_d))) + 0.5;
window_start = [((0.5.*cos(linspace(-pi,0,floor(frame_d/2)))) + 0.5) ones(1,ceil(frame_d/2))];
window_end = window_start(end:-1:1);
m_full = zeros(numchans,frameCount*frame_d);

% Create the sample-by-sample mask and windows (the code ensures that consecutive units 
% have no drop in the temporal envelope resulting from the windowing)
for i = 1:numchans
    %%%% The points at the beginning of the mask
    if m(i,1) == 1 && m(i,2) == 0
        m_full(i,1:frame_d) = window_single;
    elseif m(i,1) == 1 && m(i,2) == 1
        m_full(i,1:frame_d) = window_start;
    else
        m_full(i,1:frame_d) = 0;
    end
    %%%% The points at the end of the mask
    if m(i,frameCount) == 1 && m(i,frameCount-1) == 0
        m_full(i,(frameCount-1)*frame_d+1:frameCount*frame_d) = window_single;
    elseif m(i,frameCount) == 1 && m(i,frameCount-1) == 1
        m_full(i,(frameCount-1)*frame_d+1:frameCount*frame_d) = window_end;
    else
        m_full(i,(frameCount-1)*frame_d+1:frameCount*frame_d) = 0;
    end
    %%%% All of the points in between
    for j = 2:frameCount-1
        if m(i,j-1) == 0 && m(i,j) == 1 && m(i,j+1) == 0
            m_full(i,((j-1)*frame_d+1):((j-1)*frame_d+1)+frame_d-1) = window_single;
        elseif m(i,j-1) == 1 && m(i,j) == 1 && m(i,j+1) == 0
            m_full(i,((j-1)*frame_d+1):((j-1)*frame_d+1)+frame_d-1) = window_end;
        elseif m(i,j-1) == 0 && m(i,j) == 1 && m(i,j+1) == 1
            m_full(i,((j-1)*frame_d+1):((j-1)*frame_d+1)+frame_d-1) = window_start;
        elseif m(i,j-1) == 1 && m(i,j) == 1 && m(i,j+1) == 1
            m_full(i,((j-1)*frame_d+1):((j-1)*frame_d+1)+frame_d-1) = 1;
        else
            m_full(i,((j-1)*frame_d+1):((j-1)*frame_d+1)+frame_d-1) = 0;
        end   
    end
end

% [EOF]
