function hc = ihc_fallermerimaa(bm,env,fs)
% Perform Faller & Merimaa IHC processing on binaural data
% 
%   See also IHC_

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:58:52 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 287 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

order_n = 4;
% Compress
hc_env = env.^0.23;
% Square
hc_env = hc_env.^2;
% Filter
b_coeff = fir1(order_n,425/(fs/2));
for i = 1:size(bm,1)
    hc_env(i,:) = filter(b_coeff,1,hc_env(i,:));
end
hc_env(hc_env<0) = 0;
% Re-apply envelope
hc = (hc_env./env);
hc(isnan(hc)|isinf(hc)) = 0;
hc = hc.*max(bm,0);

% [EOF]
