function ccg = prec_lindemann(hc_L,hc_R,env_L,env_R,fs,prec_par_1,prec_par_2,maxlag_d,frame_d,frameCount,numchans,noverlap,room)
% Precedence processing according to Lindemann's model.
% 
%   See also PREC_

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

% switch room
%     case '0_00s'
%         prec_par_2 = 10;
%     case '0_32s'
%         prec_par_2 = 10;
%     case '0_47s'
%         prec_par_2 = 10;
%     case '0_68s'
%         prec_par_2 = 10;
%     case '0_89s'
%         prec_par_2 = 10;
% end

c_inh = prec_par_1;
T_inh = prec_par_2;

% Inhibition parameter
c_gamma_L = sqrt(2).*calc_rms(hc_L,2);
c_gamma_R = sqrt(2).*calc_rms(hc_R,2);
c_gamma = max([c_gamma_L c_gamma_R],[],2);

hc_L_2 = zeros(size(hc_L));
hc_R_2 = zeros(size(hc_R));

for i = 1:numchans
    hc_L_2(i,:) = (c_inh/c_gamma(i)).*hc_L(i,:);
    hc_R_2(i,:) = (c_inh/c_gamma(i)).*hc_R(i,:);
end

hc_L_2 = min(max(hc_L_2,0),1);
hc_R_2 = min(max(hc_R_2,0),1);

check_mex_compiled('-largeArrayDims','lindemann_xcorr.c')
ccg = lindemann_xcorr(hc_L_2',hc_R_2',frameCount,frame_d,maxlag_d,fs,T_inh);

% [EOF]
