function varargout = PrecSep(varargin)
% Separate 'cocktail party' mixtures of sound based on localisation
% 
%   Consult the manual for more information.
% 
%   Further Reading
% 
%   Hummersone, C. (2010), A Psychoacoustic Engineering
%   Approach to Machine Sound Source Separation in
%   Reverberant Environments, Ph.D. thesis, University of
%   Surrey.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @PrecSep_OpeningFcn, ...
                   'gui_OutputFcn',  @PrecSep_OutputFcn, ...
                   'gui_LayoutFcn',  @PrecSep_LayoutFcn, ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


function PrecSep_OpeningFcn(hObject, eventdata, handles, varargin) %#ok<INUSL>

handles.directory = fileparts(which('PrecSep.m'));
cd(handles.directory)

% Choose default command line output for PrecSep
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% set search paths
handles.path = addpath(cd,...
    [cd filesep 'Functions'],...
    [cd filesep 'Library']);

%%%%%%%%%% Build BRIR database %%%%%%%%%%

% get folders
handles.availableRooms = get_contents([cd filesep 'BRIRs'],'folders');

% Set GUI objects to room tags
set(handles.lst_available_Rooms,'string',handles.availableRooms);
set(handles.cbo_anechoic_room,'string',handles.availableRooms);

handles.available_Room_IDs = 1:length(handles.availableRooms);
handles.Rooms_to_test_IDs = [];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% get filenames

for Z = 1:length(handles.availableRooms)
    Room = handles.availableRooms{Z}; % current room

    BRIR_folder = [cd filesep 'BRIRs' filesep Room]; % path to folder with room BRIRs
    
    addpath(BRIR_folder); % add folder to search path

    filenames = get_contents(BRIR_folder,'files'); % filenames of BRIRs
    f = char(filenames);
    
    % identify common character at string start
    N = diffpoint(f);
    % remove those common characters and later characters (in the hope of extracting a number)
    f = cellstr(f(:,N:end));
    % L/R flip matrix and repeat
    f = char(cellfun(@fliplr,f,'uni',false));
    N = diffpoint(f);
    % return to vector
    f = str2double(cellfun(@fliplr,cellstr(f(:,N:end)),'uni',false));
    
    % write angles, filenames and fs
    [handles.BRIR_files.(['Room_' Room]).angles,IX] = sort(f);
    handles.BRIR_files.(['Room_' Room]).angles = handles.BRIR_files.(['Room_' Room]).angles';
    handles.BRIR_files.(['Room_' Room]).names = filenames(IX)';
    for N = 1:length(f)
        [temp,handles.BRIR_files.(['Room_' Room]).fs(N)] = wavread(handles.BRIR_files.(['Room_' Room]).names{N}); %#ok<ASGLU>
    end
end

% determine global fs
fss = merge_substruct_fields(handles.BRIR_files,'fs');
fs = mode(fss);
if any(fss~=fs)
    IR_filenames = merge_substruct_fields(handles.BRIR_files,'names');
    error_files = IR_filenames(fss~=fs);
    errormsg = [{'Inconsistent BRIR sampling frequency in:'},error_files];
    error('%s\n',errormsg{:});
else
    handles.fs = fs;
end

set(handles.txt_fs,'string',['Sampling Frequency = ' int2str(handles.fs) ' Hz'])

% Default results folder
set(handles.txt_results_file,'string',[handles.directory filesep 'Results' filesep 'results.mat'])

% load configuration file
handles.config = load_config('PrecSep.config');

% precedence model combo box
set(handles.cboPrecedenceModel,'string',handles.config.displayname)

set_prec_gui_par(hObject,handles);

[~,svnfile] = head_rev({handles.directory,...
    [handles.directory filesep 'Functions'],...
    [handles.directory filesep 'Library']});

headdate = read_svn_keyword(svnfile,'Date');
if isempty(headdate)
    warning(['SVN keyword ''Date'' not found in ' svnfile]) %#ok<WNTAG>
end
set(handles.txtSVNdate,'string',['Last Updated: ' headdate(find(isspace(headdate),1,'first')+1:end)])

handles.convd = 0;
handles.box_check = false;

handles = validate_gui(handles);
guidata(hObject,handles)

function N = diffpoint(str)

% take an input character array of strings and identify a common prefix by
% specifying the first character at which the strings differ

N = 1;
while length(unique(cellstr(str(:,N))))==1
    N = N+1;
end

function varargout = PrecSep_OutputFcn(hObject, eventdata, handles)  %#ok<INUSL>

% Get default command line output from handles structure
varargout{1} = handles.output;


function btn_preview_target_Callback(hObject, eventdata, handles) %#ok<*DEFNU,INUSL>

current_target_value = get(handles.lst_targets,'value');
target_files = get(handles.lst_targets,'string');
[temp,fs,bits] = wavread(char(target_files(current_target_value)));
sound(temp,fs,bits)


function lst_interferers_Callback(hObject, eventdata, handles) %#ok<INUSL>

handles.convd = 0;
guidata(hObject,handles)

function lst_targets_Callback(hObject, eventdata, handles) %#ok<INUSL>

handles.convd = 0;
guidata(hObject,handles)


function btn_preview_interferer_Callback(hObject, eventdata, handles) %#ok<INUSL>

current_interferer_value = get(handles.lst_interferers,'value');
interferer_files = get(handles.lst_interferers,'string');
[temp,fs,bits] = wavread(char(interferer_files(current_interferer_value)));
sound(temp,fs,bits)


function btn_remove_target_file_Callback(hObject, eventdata, handles) %#ok<INUSL>

target_files = get(handles.lst_targets,'string');
current_file = get(handles.lst_targets,'value');
target_files(current_file) = [];
set(handles.lst_targets,'Value',1);
set(handles.lst_targets,'String',target_files);
if isempty(get(handles.lst_targets,'string')) == 1
    set(hObject,'enable','off')
    set(handles.btn_preview_target,'enable','off')
end

handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles);

guidata(hObject,handles)


function btn_add_target_file_Callback(hObject, eventdata, handles) %#ok<INUSL>

d = cd;
cd([handles.directory filesep 'Stimuli'])

[targetFileName,targetPathName] = uigetfile('*.wav','MultiSelect','on');
cd('..')

if iscell(targetFileName) || ischar(targetFileName)
    if ischar(targetFileName)
        targetFileName = cellstr(targetFileName);
    end
    current_files = (get(handles.lst_targets,'string'));
    if ischar(current_files)
        if ~isempty(current_files)
            current_files = cellstr(current_files);
        end
    end
    set(handles.btn_remove_target_file,'enable','on');
    set(handles.btn_preview_target,'enable','on');
    
    set(handles.lst_targets,'value',1);
    for n = 1:length(targetFileName)
        set(handles.lst_targets,'string',[current_files; cellstr([targetPathName targetFileName{n}])]);
        current_files = get(handles.lst_targets,'string');
    end
    handles = check_mixture_variables(hObject,handles);
end

handles = validate_gui(handles);

guidata(hObject,handles)

cd(d)


function btn_remove_interferer_file_Callback(hObject, eventdata, handles) %#ok<INUSL>

interferer_files = get(handles.lst_interferers,'string');
current_file = get(handles.lst_interferers,'value');
interferer_files(current_file) = [];
set(handles.lst_interferers,'Value',1);
set(handles.lst_interferers,'String',interferer_files);
if isempty(get(handles.lst_interferers,'string')) == 1
    set(hObject,'enable','off')
    set(handles.btn_preview_interferer,'enable','off')
end

handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles);

guidata(hObject,handles)


function btn_add_interferer_file_Callback(hObject, eventdata, handles) %#ok<INUSL>

d = cd;
cd([handles.directory filesep 'Stimuli'])

[InterfererFileName,InterfererPathName] = uigetfile('*.wav','MultiSelect','on');
cd('..')

if iscell(InterfererFileName) || ischar(InterfererFileName)
    if ischar(InterfererFileName)
        InterfererFileName = cellstr(InterfererFileName);
    end
    current_files = (get(handles.lst_interferers,'string'));
    if ischar(current_files)
        if ~isempty(current_files)
            current_files = cellstr(current_files);
        end
    end
    set(handles.btn_remove_interferer_file,'enable','on');
    set(handles.btn_preview_interferer,'enable','on');
    
    set(handles.lst_interferers,'value',1);
    for n = 1:length(InterfererFileName)
        set(handles.lst_interferers,'string',[current_files; cellstr([InterfererPathName InterfererFileName{n}])]);
        current_files = get(handles.lst_interferers,'string');
    end
    handles = check_mixture_variables(hObject,handles);
end

handles = validate_gui(handles);

guidata(hObject,handles)

cd(d)


function btnAddRoom_Callback(hObject, eventdata, handles)  %#ok<INUSL>

if ~isempty(handles.available_Room_IDs)
    available_Room_value = get(handles.lst_available_Rooms,'Value');
    available_Room_ID = handles.available_Room_IDs(available_Room_value);
    handles.Rooms_to_test_IDs = sort([handles.Rooms_to_test_IDs available_Room_ID]);
    handles.available_Room_IDs(available_Room_value) = [];

    set(handles.lst_available_Rooms,'value',1);
    set(handles.lst_Rooms,'value',1);
    set(handles.lst_available_Rooms,'string',handles.availableRooms(handles.available_Room_IDs));
    set(handles.lst_Rooms,'string',handles.availableRooms(handles.Rooms_to_test_IDs));
end

handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles);
guidata(hObject, handles);


function btnAddAllRooms_Callback(hObject, eventdata, handles) %#ok<INUSL>

if ~isempty(handles.available_Room_IDs)
    handles.Rooms_to_test_IDs = sort([handles.Rooms_to_test_IDs handles.available_Room_IDs]);
    handles.available_Room_IDs = [];

    set(handles.lst_available_Rooms,'value',1);
    set(handles.lst_Rooms,'value',1);
    set(handles.lst_available_Rooms,'string',handles.availableRooms(handles.available_Room_IDs));
    set(handles.lst_Rooms,'string',handles.availableRooms(handles.Rooms_to_test_IDs));
end

handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles);
guidata(hObject, handles);


function btnRemoveRoom_Callback(hObject, eventdata, handles) %#ok<INUSL>

if ~isempty(handles.Rooms_to_test_IDs)
    Room_to_test_value = get(handles.lst_Rooms,'Value');
    Room_to_test_ID = handles.Rooms_to_test_IDs(Room_to_test_value);
    handles.available_Room_IDs = sort([handles.available_Room_IDs Room_to_test_ID]);
    handles.Rooms_to_test_IDs(Room_to_test_value) = [];

    set(handles.lst_available_Rooms,'value',1);
    set(handles.lst_Rooms,'value',1);
    set(handles.lst_available_Rooms,'string',handles.availableRooms(handles.available_Room_IDs));
    set(handles.lst_Rooms,'string',handles.availableRooms(handles.Rooms_to_test_IDs));
end

handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles);
guidata(hObject, handles);


function btnRemoveAllRooms_Callback(hObject, eventdata, handles) %#ok<INUSL>

if ~isempty(handles.Rooms_to_test_IDs)
    handles.available_Room_IDs = sort([handles.available_Room_IDs handles.Rooms_to_test_IDs]);
    handles.Rooms_to_test_IDs = [];

    set(handles.lst_available_Rooms,'value',1);
    set(handles.lst_Rooms,'value',1);
    set(handles.lst_available_Rooms,'string',handles.availableRooms(handles.available_Room_IDs));
    set(handles.lst_Rooms,'string',handles.availableRooms(handles.Rooms_to_test_IDs));
end

handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles);
guidata(hObject, handles);


function lst_Rooms_Callback(hObject, eventdata, handles) %#ok<INUSL>

handles.convd = 0;
guidata(hObject,handles)


function txt_azimuth_target_Callback(hObject, eventdata, handles) %#ok<INUSL>

angles = unique(merge_substruct_fields(handles.BRIR_files,'angles'));
handles.box_check = any(~ismember(eval(get(hObject,'string')),angles)) | ~(isvector(eval(get(hObject,'string'))) | isscalar(eval(get(hObject,'string'))));
handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles,hObject);
guidata(hObject,handles)


function txt_azimuth_interferer_Callback(hObject, eventdata, handles) %#ok<INUSL>

angles = unique(merge_substruct_fields(handles.BRIR_files,'angles'));
handles.box_check = any(~ismember(eval(get(hObject,'string')),angles))  | ~(isvector(eval(get(hObject,'string'))) | isscalar(eval(get(hObject,'string'))));
handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles,hObject);
guidata(hObject,handles)


function txt_TIR_Callback(hObject, eventdata, handles)  %#ok<INUSL>

handles.box_check = ~(isvector(eval(get(hObject,'string'))) | isscalar(eval(get(hObject,'string'))));
handles = check_mixture_variables(hObject,handles);
handles = validate_gui(handles,hObject);
guidata(hObject,handles)


function btn_preview_mixture_Callback(hObject, eventdata, handles) %#ok<INUSL>

if handles.convd~=1
    Rooms = handles.availableRooms(handles.Rooms_to_test_IDs);
    Room_choice = get(handles.lst_Rooms,'value');

    user_tir = eval(get(handles.txt_TIR,'string'));
    TIR = user_tir(1);

    target_files = get(handles.lst_targets,'string'); % Array of filenames for target intrusion
    target_choice = get(handles.lst_targets,'value');
    interferer_files = get(handles.lst_interferers,'string'); % Array of filenames for interferer intrusion
    interferer_choice = get(handles.lst_interferers,'value');

    user_azimuth_target = eval(get(handles.txt_azimuth_target,'string'));
    user_azimuth_interferer = eval(get(handles.txt_azimuth_interferer,'string'));
    azimuth_t = user_azimuth_target(1);
    azimuth_n = user_azimuth_interferer(1);

    the_target_wavs = check_stimuli(target_files,handles.fs);
    the_interferer_wavs = check_stimuli(interferer_files,handles.fs);
    difflength = size(the_target_wavs,1)-size(the_interferer_wavs,1);
    if difflength>0
        the_interferer_wavs = [the_interferer_wavs; zeros(difflength,size(the_interferer_wavs,2))];
    elseif difflength<0
        the_target_wavs = [the_target_wavs; zeros(-difflength,size(the_target_wavs,2))];
    end

    handles.mixture = create_mixture(handles.BRIR_files,the_target_wavs(:,target_choice),the_interferer_wavs(:,interferer_choice),char(Rooms(Room_choice)),...
        azimuth_t,azimuth_n,TIR,handles.fs);
    
    handles.convd = 1;
end

sound(0.5/max(handles.mixture(:)).*handles.mixture,handles.fs,16)

guidata(hObject, handles);


function btn_browse_results_file_Callback(hObject, eventdata, handles) %#ok<INUSL>

ResultsPathName = uigetdir;

if ~isempty(ResultsPathName)
    set(handles.txt_results_file,'string',[ResultsPathName filesep 'results.mat']);
end

handles = validate_gui(handles);

guidata(hObject,handles)


function cboPrecedenceModel_Callback(hObject, eventdata, handles)

set_prec_gui_par(hObject,handles);

txtPrecedenceParameter1_Callback(handles.txtPrecedenceParameter1, eventdata, handles)
txtPrecedenceParameter2_Callback(handles.txtPrecedenceParameter2, eventdata, handles)


function txtPrecedenceParameter1_Callback(hObject, eventdata, handles) %#ok<INUSL>

prec_par_1 = eval(get(hObject,'string'));
displaynames = get(handles.cboPrecedenceModel,'string'); displayname_v = get(handles.cboPrecedenceModel,'value');
displayname = displaynames{displayname_v};
% choose illegal precedence parameter values
switch displayname
    case 'Baseline'
        pp1_status = any(prec_par_1<0);
    case 'Martin'
        pp1_status = any(prec_par_1<0);
    case 'Faller & Merimaa'
        pp1_status = any(prec_par_1<0) | any(prec_par_1>1);
    case 'Lindemann'
        pp1_status = any(prec_par_1<=0) | any(prec_par_1>1);
    case 'Macpherson'
        pp1_status = any(prec_par_1<0);
    case {'Combo A','Combo B','Combo C','Combo D','Combo E','Combo F','Combo G','Combo H'}
        pp1_status = any(prec_par_1<0);
    case {'Combo2 A','Combo2 B','Combo2 C','Combo2 D','Combo2 E','Combo2 F','Combo2 G','Combo2 H'}
        pp1_status = any(prec_par_1<0) | any(prec_par_1>1);
    otherwise
        disp('Information: no valid precedence paramater range specified.')
        dbstack
        pp1_status = false;
end

handles.box_check = ~(isvector(eval(get(hObject,'string'))) | isscalar(eval(get(hObject,'string')))) | pp1_status;

handles = validate_gui(handles,hObject);

guidata(hObject, handles);


function txtPrecedenceParameter2_Callback(hObject, eventdata, handles) %#ok<INUSL>

prec_par_2 = eval(get(hObject,'string'));
displaynames = get(handles.cboPrecedenceModel,'string'); displayname_v = get(handles.cboPrecedenceModel,'value');
displayname = displaynames{displayname_v};
% choose illegal precedence parameter values
switch displayname
    case 'Baseline'
        pp2_status = any(prec_par_2<0);
    case 'Martin'
        pp2_status = any(prec_par_2<0);
    case 'Faller & Merimaa'
        pp2_status = any(prec_par_2<0);
    case 'Lindemann'
        pp2_status = any(prec_par_2<0);
    case 'Macpherson'
        pp2_status = any(prec_par_2<0);
    case {'Combo A','Combo B','Combo C','Combo D','Combo E','Combo F','Combo G','Combo H'}
        pp2_status = any(prec_par_2<0);
    case {'Combo2 A','Combo2 B','Combo2 C','Combo2 D'}
        pp2_status = numel(prec_par_2)>1;
    otherwise
        disp('Information: no valid precedence paramater range specified.')
        dbstack
        pp2_status = false;
end

handles.box_check = ~(isvector(eval(get(hObject,'string'))) | isscalar(eval(get(hObject,'string')))) | pp2_status;

handles = validate_gui(handles,hObject);

guidata(hObject, handles);


function txt_lowcf_Callback(hObject, eventdata, handles) %#ok<INUSL>

cf = str2double(get(hObject,'string'));
max_cf = handles.fs/2;

handles.box_check = cf<0 | cf>max_cf | cf>str2double(get(handles.txt_highcf,'string')) | str2double(get(handles.txt_highcf,'string'))<0;

handles = validate_gui(handles,hObject);

guidata(hObject, handles);


function txt_highcf_Callback(hObject, eventdata, handles) %#ok<INUSL>

cf = str2double(get(hObject,'string'));
max_cf = handles.fs/2; % get_max_cf(handles.fs,96);

handles.box_check = cf<0 | cf>max_cf | cf<str2double(get(handles.txt_lowcf,'string')) | str2double(get(handles.txt_lowcf,'string'))<0;

handles = validate_gui(handles,hObject);

guidata(hObject, handles);


function txt_numchans_Callback(hObject, eventdata, handles) %#ok<INUSL>

numchans = str2double(get(hObject,'string'));

handles.box_check = numchans < 0 | ~isscalarinteger(numchans);

handles = validate_gui(handles,hObject);

guidata(hObject, handles);


function txt_maxlag_Callback(hObject, eventdata, handles) %#ok<INUSL>

maxlag = str2double(get(hObject,'string'));

handles.box_check = maxlag < 0;

handles = validate_gui(handles,hObject);

guidata(hObject, handles);


function txt_frame_Callback(hObject, eventdata, handles) %#ok<INUSL>

frame = str2double(get(hObject,'string'));

handles.box_check = frame < 0;

handles = validate_gui(handles,hObject);

guidata(hObject, handles);


function txt_noverlap_Callback(hObject, eventdata, handles) %#ok<INUSL>

noverlap = str2double(get(hObject,'string'));

handles.box_check = noverlap < 0 | ~isscalarinteger(noverlap);

handles = validate_gui(handles,hObject);

guidata(hObject, handles);


function theWindow_CloseRequestFcn(hObject, eventdata, handles) %#ok<INUSL>

path(handles.path);
delete(hObject);


function btn_GO_Callback(hObject, eventdata, handles) %#ok<INUSL>

separate(hObject,handles)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% SUB-FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function sfhandles = set_prec_gui_par(hObject,sfhandles)

available_models = get(sfhandles.cboPrecedenceModel,'string');
chosen_model = get(sfhandles.cboPrecedenceModel,'value');
displayname = available_models{chosen_model};

% Precedence Parameters
set(sfhandles.txtPrecedenceParameter1,'string',...
        get_model_parameter(sfhandles.config,displayname,'prec_par_1'))
set(sfhandles.lbl_prec_par1,'string',...
        [get_model_parameter(sfhandles.config,displayname,'prec_par_1_label') ':'])
set(sfhandles.txtPrecedenceParameter2,'string',...
        get_model_parameter(sfhandles.config,displayname,'prec_par_2'))
set(sfhandles.lbl_prec_par2,'string',...
        [get_model_parameter(sfhandles.config,displayname,'prec_par_2_label') ':'])

% Other parameters
set(sfhandles.txt_noverlap,'string',...
    get_model_parameter(sfhandles.config,displayname,'noverlap'))
set(sfhandles.txt_noverlap,'enable',...
    get_model_parameter(sfhandles.config,displayname,'noverlap_enable'))
set(sfhandles.cboIHCmodel,'value',...
    eval(get_model_parameter(sfhandles.config,displayname,'IHC_model')))

guidata(hObject,sfhandles)


function sfhandles = check_mixture_variables(hObject,sfhandles)

if ~isempty(get(sfhandles.lst_Rooms,'string')) ...
        && ~isempty(get(sfhandles.txt_TIR,'string')) ...
        && ~isempty(get(sfhandles.txt_azimuth_target,'string')) ...
        && ~isempty(get(sfhandles.txt_azimuth_interferer,'string')) ...
        && ~isempty(get(sfhandles.lst_targets,'string')) ...
        && ~isempty(get(sfhandles.lst_interferers,'string'))
%
    set(sfhandles.btn_preview_mixture,'enable','on')
else
    set(sfhandles.btn_preview_mixture,'enable','off')
end

sfhandles.convd = 0;

guidata(hObject,sfhandles)


function sfhandles = validate_gui(sfhandles,sfhObject)

if ~isempty(get(sfhandles.lst_Rooms,'string'))...
        && ~isempty(get(sfhandles.txt_TIR,'string'))...
        && ~isempty(get(sfhandles.txt_azimuth_target,'string'))...
        && ~isempty(get(sfhandles.txt_azimuth_interferer,'string'))...
        && ~isempty(get(sfhandles.lst_targets,'string'))...
        && ~isempty(get(sfhandles.lst_interferers,'string'))...
        && ~isempty(get(sfhandles.txt_lowcf,'string'))...
        && ~isempty(get(sfhandles.txt_highcf,'string'))...
        && ~isempty(get(sfhandles.txt_numchans,'string'))...
        && ~isempty(get(sfhandles.txt_maxlag,'string'))...
        && ~isempty(get(sfhandles.txt_frame,'string'))...
        && ~isempty(get(sfhandles.txt_noverlap,'string'))...
        && ~isempty(get(sfhandles.txtPrecedenceParameter1,'string'))...
        && ~isempty(get(sfhandles.txtPrecedenceParameter2,'string'))...
        && ~isempty(get(sfhandles.txt_results_file,'string'))...
        && (length(eval(get(sfhandles.txt_azimuth_target,'string')))...
        == length(eval(get(sfhandles.txt_azimuth_interferer,'string'))))...
        && ~sfhandles.box_check
    set(sfhandles.btn_GO,'enable','on')
else
    set(sfhandles.btn_GO,'enable','off')
end

if nargin>1
    if ~sfhandles.box_check
        set(sfhObject,'BackgroundColor','w')
    else
        set(sfhObject,'BackgroundColor','y')
    end
end

angles = unique(merge_substruct_fields(sfhandles.BRIR_files,'angles'));
if (length(eval(get(sfhandles.txt_azimuth_target,'string')))...
        == length(eval(get(sfhandles.txt_azimuth_interferer,'string')))) && ...
        ~(any(~ismember(eval(get(sfhandles.txt_azimuth_target,'string')),angles)) || ...
        any(~ismember(eval(get(sfhandles.txt_azimuth_interferer,'string')),angles)))
    set(sfhandles.txt_azimuth_target,'BackgroundColor','w')
    set(sfhandles.txt_azimuth_interferer,'BackgroundColor','w')
else
    set(sfhandles.txt_azimuth_target,'BackgroundColor','y')
    set(sfhandles.txt_azimuth_interferer,'BackgroundColor','y')
end

if ~sfhandles.box_check
    if str2double(get(sfhandles.txt_highcf,'string'))<str2double(get(sfhandles.txt_lowcf,'string')) ...
             || str2double(get(sfhandles.txt_lowcf,'string'))<0  || str2double(get(sfhandles.txt_highcf,'string'))<0
        set(sfhandles.txt_lowcf,'BackgroundColor','y')
        set(sfhandles.txt_highcf,'BackgroundColor','y')
    else
        set(sfhandles.txt_lowcf,'BackgroundColor','w')
        set(sfhandles.txt_highcf,'BackgroundColor','w')
    end
end


function array = merge_substruct_fields(structure,field)

f = fieldnames(structure);

array = [];

for F = 1:length(f)
    array = [array structure.(f{F}).(field)]; %#ok<AGROW>
end


function status = isscalarinteger(x)

y = x-round(x);

status = isscalar(x) & y==0;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% GUI Objects %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Creates and returns a handle to the GUI figure. 
function h1 = PrecSep_LayoutFcn(policy)
% policy - create a new figure or use a singleton. 'new' or 'reuse'.

persistent hsingleton;
if strcmpi(policy, 'reuse') & ishandle(hsingleton) %#ok<AND2>
    h1 = hsingleton;
    return;
end

appdata = [];
appdata.GUIDEOptions = struct(...
    'active_h', [], ...
    'taginfo', struct(...
    'figure', 2, ...
    'uipanel', 17, ...
    'togglebutton', 4, ...
    'listbox', 6, ...
    'popupmenu', 15, ...
    'text', 60, ...
    'edit', 38, ...
    'checkbox', 13, ...
    'slider', 4, ...
    'pushbutton', 25, ...
    'axes', 3), ...
    'override', 1, ...
    'release', 13, ...
    'resize', 'none', ...
    'accessibility', 'callback', ...
    'mfile', 1, ...
    'callbacks', 1, ...
    'singleton', 1, ...
    'syscolorfig', 1, ...
    'blocking', 0, ...
    'lastSavedFile', '/Volumes/chris/Documents/MATLAB/PrecSep_beta/PrecSep.m', ...
    'lastFilename', '/Volumes/chris/Documents/MATLAB/PrecSep_beta/PrecSep_source.fig');
appdata.lastValidTag = 'theWindow';
appdata.GUIDELayoutEditor = [];
appdata.initTags = struct(...
    'handle', [], ...
    'tag', 'theWindow');


%%%%%%%%%%%%%% Main figure window %%%%%%%%%%%%%%

h1 = figure(...
'PaperUnits',get(0,'defaultfigurePaperUnits'),...
'CloseRequestFcn',@(hObject,eventdata)PrecSep('theWindow_CloseRequestFcn',hObject,eventdata,guidata(hObject)),...
'Color',[0.7 0.7 0.7],...
'IntegerHandle','off',...
'InvertHardcopy',get(0,'defaultfigureInvertHardcopy'),...
'MenuBar','none',...
'Name','A Localisation- and Precedence-based Binaural Separation Algorithm',...
'NumberTitle','off',...
'PaperPosition',get(0,'defaultfigurePaperPosition'),...
'PaperSize',[20.98404194812 29.67743169791],...
'PaperType',get(0,'defaultfigurePaperType'),...
'Position',[623 110 880 740],...
'Resize','off',...
'HandleVisibility','callback',...
'Interruptible','off',...
'Tag','theWindow',...
'UserData',[],...
'Visible','on',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

titlebox = uicontrol(...
'Parent',h1,...
'FontUnits','pixels',...
'FontSize',14,...
'HorizontalAlignment','left',...
'Position',[40 695 800 25],...
'String','A Localisation- and Precedence-based Binaural Separation Algorithm',...
'Style','text',...
'Tag','text41',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uistack(titlebox,'top') 

uicontrol(...
'Parent',h1,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','right',...
'Position',[540 700 300 20],...
'String','Sampling Frequency = ',...
'Style','text',...
'TooltipString','The master sampling frequency is determined by the sampling frequency of the BRIR database',...
'Tag','txt_fs',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h1,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_GO_Callback',hObject,eventdata,guidata(hObject)),...
'FontSize',22,...
'Position',[640 20 100 40],...
'String','GO!',...
'TooltipString','SEPARATE!',...
'Tag','btn_GO',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h1,...
'FontUnits','pixels',...
'CData',[],...
'FontSize',9,...
'Position',[0 0 880 20],...
'String',' Chris Hummersone & University of Surrey, 2011',...
'Style','text',...
'Tag','text55',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h1,...
'FontUnits','pixels',...
'CData',[],...
'FontSize',9,...
'HorizontalAlignment','left',...
'Position',[10 0 300 20],...
'String','',...
'Style','text',...
'Tag','txtSVNdate',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );


%%%%%%%%%%%%%% Mixture Variables %%%%%%%%%%%%%%

h_mix_panel = uipanel(...
'Parent',h1,...
'Units','pixels',...
'FontUnits','pixels',...
'BorderType','line',...
'FontSize',11,...
'Title','Mixture Variables',...
'Tag','CV_panel',...
'UserData',[],...
'Clipping','on',...
'Position',[40 200 460 480],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 440 140 20],...
'String','Target Sound Files:',...
'Style','text',...
'Tag','text45',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('lst_targets_Callback',hObject,eventdata,guidata(hObject)),...
'FontSize',11,...
'Max',20,...
'Position',[20 360 420 80],...
'Style','listbox',...
'TooltipString','The chosen target sound file(s)',...
'Value',1,...
'Tag','lst_targets',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_preview_target_Callback',hObject,eventdata,guidata(hObject)),...
'Enable','off',...
'FontSize',11,...
'Position',[220 320 60 20],...
'String','Preview',...
'TooltipString','Preview the selected target sound file',...
'Tag','btn_preview_target',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_add_target_file_Callback',hObject,eventdata,guidata(hObject)),...
'FontSize',11,...
'Position',[380 320 60 20],...
'String','Add',...
'TooltipString','Add target sound file(s)',...
'Tag','btn_add_target_file',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_remove_target_file_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'Enable','off',...
'FontSize',11,...
'Position',[300 320 60 20],...
'String','Remove',...
'TooltipString','Remove the selected targt sound files (ctrl/cmd+click to multi-select)',...
'Tag','btn_remove_target_file',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 300 140 20],...
'String','Interferer Sound Files:',...
'Style','text',...
'Tag','text45',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_preview_interferer_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'Enable','off',...
'FontSize',11,...
'Position',[220 180 60 20],...
'String','Preview',...
'TooltipString','Preview the selected interferer sound file',...
'Tag','btn_preview_interferer',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_add_interferer_file_Callback',hObject,eventdata,guidata(hObject)),...
'FontSize',11,...
'Position',[380 180 60 20],...
'String','Add',...
'TooltipString','Add interferer sound file(s)',...
'Tag','btn_add_interferer_file',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_remove_interferer_file_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'Enable','off',...
'FontSize',11,...
'Position',[300 180 60 20],...
'String','Remove',...
'TooltipString','Remove the selected interferer sound files (ctrl/cmd+click to multi-select)',...
'Tag','btn_remove_interferer_file',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('lst_interferers_Callback',hObject,eventdata,guidata(hObject)),...
'FontSize',11,...
'Max',20,...
'Position',[20 220 420 80],...
'Style','listbox',...
'TooltipString','The chosen interferer sound file(s)',...
'Value',1,...
'Tag','lst_interferers',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[230 95 100 30],...
'String',{  'Interferer'; 'Azimuth [deg]:' },...
'Style','text',...
'Tag','text5',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'CData',[],...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[230 135 100 30],...
'String',{  'Target'; 'Azimuth [deg]:' },...
'Style','text',...
'Tag','text43',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 160 100 20],...
'String','Rooms:',...
'Style','text',...
'Tag','text3',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btnAddRoom_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[100 120 20 20],...
'String','<html>&#8594</html>',...
'TooltipString','Add the selected available room',...
'Tag','btnAddRoom',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btnAddAllRooms_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[100 100 20 20],...
'String','<html>&#8658</html>',...
'TooltipString','Add all available rooms',...
'Tag','btnAddAllRooms',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btnRemoveRoom_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[100 80 20 20],...
'String','<html>&#8592</html>',...
'TooltipString','Remove the selected room to test',...
'Tag','btnRemoveRoom',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btnRemoveAllRooms_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[100 60 20 20],...
'String','<html>&#8656</html>',...
'TooltipString','Remove all Rooms to test',...
'Tag','btnRemoveAllRooms',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 140 80 20],...
'String','Available:',...
'Style','text',...
'Tag','text49',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[140 140 80 20],...
'String','To Test:',...
'Style','text',...
'Tag','text50',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[230 55 110 30],...
'String',{  'Target-to-Interferer'; 'Ratio [dB]:' },...
'Style','text',...
'Tag','text6',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_preview_mixture_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'Enable','off',...
'FontSize',11,...
'Position',[340 20 100 20],...
'String','Preview Mixture',...
'TooltipString','Preview the ''cocktail party'' mixture incorporating the currently selected interferer and RT60, and the first TIR and azimuth pair',...
'Tag','btn_preview_mixture',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'CData',[],...
'FontSize',11,...
'Max',20,...
'Position',[20 60 60 80],...
'Style','listbox',...
'TooltipString','The available rooms',...
'Value',1,...
'Tag','lst_available_Rooms',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('lst_Rooms_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Max',20,...
'Position',[140 60 60 80],...
'Style','listbox',...
'TooltipString','Rooms to test',...
'Value',1,...
'Tag','lst_Rooms',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_azimuth_target_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[340 140 100 20],...
'String','-5',...
'Style','edit',...
'TooltipString','Enter the desired target azimuth or MATLAB expression that evaluates to a vector of azimuths',...
'Tag','txt_azimuth_target',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_azimuth_interferer_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[340 100 100 20],...
'String','5',...
'Style','edit',...
'TooltipString','Enter the desired interferer azimuth or MATLAB expression that evaluates to a vector of azimuths',...
'Tag','txt_azimuth_interferer',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_mix_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_TIR_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[340 60 100 20],...
'String','0',...
'Style','edit',...
'TooltipString','Enter the desired Target-to-Interferer Ratio(s). Any numeric value or MATLAB expression that evaluates to a vector is acceptable.',...
'Tag','txt_TIR',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );


%%%%%%%%%%%%%% Results %%%%%%%%%%%%%%

h_results_panel = uipanel(...
'Parent',h1,...
'Units','pixels',...
'FontUnits','pixels',...
'FontSize',11.5,...
'Title','Results',...
'Tag','uipanel16',...
'Clipping','on',...
'Position',[40 40 460 140],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_results_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 80 420 20],...
'String',blanks(0),...
'Style','edit',...
'TooltipString','The results file directory and file name',...
'Tag','txt_results_file',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_results_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 100 160 20],...
'String','Directory:',...
'Style','text',...
'Tag','text54',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_results_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('btn_browse_results_file_Callback',hObject,eventdata,guidata(hObject)),...
'FontSize',11,...
'Position',[380 40 60 20],...
'String','Browse',...
'TooltipString','Choose the results file directory',...
'Tag','btn_browse_results_file',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_results_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'Position',[20 20 120 20],...
'String','Listen to result?',...
'TooltipString','Listen to the separated/resynthesised target?',...
'Style','checkbox',...
'Value',1,...
'Tag','chkPlay',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_results_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'Position',[140 20 161 20],...
'String','Save result .wav file?',...
'TooltipString','Save the separated/resynthesised target to a wave file?',...
'Style','checkbox',...
'Value',1,...
'Tag','chkSave',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );


%%%%%%%%%%%%%% IHC Model %%%%%%%%%%%%%%

h_IHC_panel = uipanel(...
'Parent',h1,...
'Units','pixels',...
'FontUnits','pixels',...
'FontSize',11,...
'Title','Inner Hair Cell Model',...
'Tag','uipanel15',...
'Clipping','on',...
'Position',[540 600 300 80],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_IHC_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 20 50 20],...
'String','Model:',...
'Style','text',...
'Tag','text56',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_IHC_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'Position',[120 20 160 20],...
'String',{  'Half-wave Rectify'; 'Meddis'; 'Faller & Merimaa'; 'Bypass' },...
'Style','popupmenu',...
'TooltipString','Choose the Inner Hair Cell model',...
'Value',1,...
'Tag','cboIHCmodel',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );


%%%%%%%%%%%%%% Precedence Model %%%%%%%%%%%%%%

h_prec_panel = uipanel(...
'Parent',h1,...
'Units','pixels',...
'FontUnits','pixels',...
'FontSize',11,...
'Title','Precedence Model',...
'Tag','uipanel14',...
'Clipping','on',...
'Position',[540 420 300 160],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_prec_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txtPrecedenceParameter1_Callback',hObject,eventdata,guidata(hObject)),...
'FontSize',11,...
'Position',[200 60 80 20],...
'String','1',...
'Style','edit',...
'TooltipString','Enter any value or expression that evaluates to a MATLAB vector. Each precedence model has a specific range of acceptable values.',...
'Tag','txtPrecedenceParameter1',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_prec_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 100 50 20],...
'String','Model:',...
'Style','text',...
'Tag','text52',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_prec_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 60 180 20],...
'String','Precedence Parameter 1:',...
'Style','text',...
'Tag','lbl_prec_par1',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_prec_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txtPrecedenceParameter2_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[200 20 80 20],...
'String','1',...
'Style','edit',...
'TooltipString','Enter any value or expression that evaluates to a MATLAB vector. Each precedence model has a specific range of acceptable values.',...
'Tag','txtPrecedenceParameter2',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_prec_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 20 180 20],...
'String','Precedence Parameter 2:',...
'Style','text',...
'Tag','lbl_prec_par2',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_prec_panel,...
'FontUnits','pixels',...
'Callback',@(hObject,eventdata)PrecSep('cboPrecedenceModel_Callback',hObject,eventdata,guidata(hObject)),...
'FontSize',11,...
'Position',[120 100 160 20],...
'String',{  'Baseline'; 'Martin'; 'Faller & Merimaa'; 'Lindemann'; 'Macpherson' },...
'Style','popupmenu',...
'TooltipString','Choose the localisation/precedence model',...
'Value',1,...
'Tag','cboPrecedenceModel',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );


%%%%%%%%%%%%%% Other Variables %%%%%%%%%%%%%%

h_other_panel = uipanel(...
'Parent',h1,...
'Units','pixels',...
'FontUnits','pixels',...
'BorderType','line',...
'FontSize',11,...
'Title','Other variables',...
'Tag','uipanel7',...
'Clipping','on',...
'Position',[540 80 300 320],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 60 160 20],...
'String','Frame Length [ms]:',...
'Style','text',...
'Tag','text18',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 15 160 30],...
'String',{  'No. of frames to overlap'; 'for localisation:' },...
'Style','text',...
'Tag','text42',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_lowcf_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[200 220 80 20],...
'String','50',...
'Style','edit',...
'TooltipString','Low centre frequency of gammatone filterbank',...
'Tag','txt_lowcf',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_highcf_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[200 180 80 20],...
'String','7500',...
'Style','edit',...
'TooltipString','High centre frequency of gammatone filterbank',...
'Tag','txt_highcf',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 180 160 20],...
'String','High CF [Hz]:',...
'Style','text',...
'Tag','text8',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_numchans_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[200 140 80 20],...
'String','32',...
'Style','edit',...
'TooltipString','Number of gammatone filterbank channels',...
'Tag','txt_numchans',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 140 160 20],...
'String','No. of channels:',...
'Style','text',...
'Tag','text9',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 220 160 20],...
'String','Low CF [Hz]:',...
'Style','text',...
'Tag','text7',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_maxlag_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[200 100 80 20],...
'String','1',...
'Style','edit',...
'TooltipString','Maximum lag for the cross-correlation',...
'Tag','txt_maxlag',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_frame_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[200 60 80 20],...
'String','10',...
'Style','edit',...
'TooltipString','Length of the analysis window',...
'Tag','txt_frame',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'Callback',@(hObject,eventdata)PrecSep('txt_noverlap_Callback',hObject,eventdata,guidata(hObject)),...
'CData',[],...
'FontSize',11,...
'Position',[200 20 80 20],...
'String','3',...
'Style','edit',...
'TooltipString','Number of frames over which to calculate the cross-correlogram',...
'Tag','txt_noverlap',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 100 180 20],...
'String','Max cross-correlation lag [ms]:',...
'Style','text',...
'Tag','text16',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'HorizontalAlignment','left',...
'Position',[20 260 100 20],...
'String','Anechoic Room:',...
'Style','text',...
'Tag','text59',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

uicontrol(...
'Parent',h_other_panel,...
'FontUnits','pixels',...
'FontSize',11,...
'Position',[120 260 160 20],...
'String','1',...
'Style','popupmenu',...
'TooltipString','Choose the anechoic room',...
'Value',1,...
'Tag','cbo_anechoic_room',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

hsingleton = h1;


% --- Set application data first then calling the CreateFcn. 
function local_CreateFcn(hObject, eventdata, createfcn, appdata)

if ~isempty(appdata)
   names = fieldnames(appdata);
   for i=1:length(names)
       name = char(names(i));
       setappdata(hObject, name, getfield(appdata,name)); %#ok<GFLD>
   end
end

if ~isempty(createfcn)
   if isa(createfcn,'function_handle')
       createfcn(hObject, eventdata);
   else
       eval(createfcn);
   end
end


% --- Handles default GUIDE GUI creation and callback dispatch
function varargout = gui_mainfcn(gui_State, varargin)

gui_StateFields =  {'gui_Name'
    'gui_Singleton'
    'gui_OpeningFcn'
    'gui_OutputFcn'
    'gui_LayoutFcn'
    'gui_Callback'};
gui_Mfile = '';
for i=1:length(gui_StateFields)
    if ~isfield(gui_State, gui_StateFields{i})
        error('MATLAB:gui_mainfcn:FieldNotFound', 'Could not find field %s in the gui_State struct in GUI M-file %s', gui_StateFields{i}, gui_Mfile);
    elseif isequal(gui_StateFields{i}, 'gui_Name')
        gui_Mfile = [gui_State.(gui_StateFields{i}), '.m'];
    end
end

numargin = length(varargin);

if numargin == 0
    % PRECSEP
    % create the GUI only if we are not in the process of loading it
    % already
    gui_Create = true;
elseif local_isInvokeActiveXCallback(gui_State, varargin{:})
    % PRECSEP(ACTIVEX,...)
    vin{1} = gui_State.gui_Name;
    vin{2} = [get(varargin{1}.Peer, 'Tag'), '_', varargin{end}];
    vin{3} = varargin{1};
    vin{4} = varargin{end-1};
    vin{5} = guidata(varargin{1}.Peer);
    feval(vin{:});
    return;
elseif local_isInvokeHGCallbak(gui_State, varargin{:})
    % PRECSEP('CALLBACK',hObject,eventData,handles,...)
    gui_Create = false;
else
    % PRECSEP(...)
    % create the GUI and hand varargin to the openingfcn
    gui_Create = true;
end

if ~gui_Create
    % In design time, we need to mark all components possibly created in
    % the coming callback evaluation as non-serializable. This way, they
    % will not be brought into GUIDE and not be saved in the figure file
    % when running/saving the GUI from GUIDE.
    designEval = false;
    if (numargin>1 && ishghandle(varargin{2}))
        fig = varargin{2};
        while ~isempty(fig) && ~isa(handle(fig),'figure')
            fig = get(fig,'parent');
        end
        
        designEval = isappdata(0,'CreatingGUIDEFigure') || isprop(fig,'__GUIDEFigure');
    end
        
    if designEval
        beforeChildren = findall(fig);
    end
    
    % evaluate the callback now
    varargin{1} = gui_State.gui_Callback;
    if nargout
        [varargout{1:nargout}] = feval(varargin{:});
    else       
        feval(varargin{:});
    end
    
    % Set serializable of objects created in the above callback to off in
    % design time. Need to check whether figure handle is still valid in
    % case the figure is deleted during the callback dispatching.
    if designEval && ishandle(fig)
        set(setdiff(findall(fig),beforeChildren), 'Serializable','off');
    end
else
    if gui_State.gui_Singleton
        gui_SingletonOpt = 'reuse';
    else
        gui_SingletonOpt = 'new';
    end

    % Check user passing 'visible' P/V pair first so that its value can be
    % used by oepnfig to prevent flickering
    gui_Visible = 'auto';
    gui_VisibleInput = '';
    for index=1:2:length(varargin)
        if length(varargin) == index || ~ischar(varargin{index})
            break;
        end

        % Recognize 'visible' P/V pair
        len1 = min(length('visible'),length(varargin{index}));
        len2 = min(length('off'),length(varargin{index+1}));
        if ischar(varargin{index+1}) && strncmpi(varargin{index},'visible',len1) && len2 > 1
            if strncmpi(varargin{index+1},'off',len2)
                gui_Visible = 'invisible';
                gui_VisibleInput = 'off';
            elseif strncmpi(varargin{index+1},'on',len2)
                gui_Visible = 'visible';
                gui_VisibleInput = 'on';
            end
        end
    end
    
    % Open fig file with stored settings.  Note: This executes all component
    % specific CreateFunctions with an empty HANDLES structure.

    
    % Do feval on layout code in m-file if it exists
    gui_Exported = ~isempty(gui_State.gui_LayoutFcn);
    % this application data is used to indicate the running mode of a GUIDE
    % GUI to distinguish it from the design mode of the GUI in GUIDE. it is
    % only used by actxproxy at this time.   
    setappdata(0,genvarname(['OpenGuiWhenRunning_', gui_State.gui_Name]),1);
    if gui_Exported
        gui_hFigure = feval(gui_State.gui_LayoutFcn, gui_SingletonOpt);

        % make figure invisible here so that the visibility of figure is
        % consistent in OpeningFcn in the exported GUI case
        if isempty(gui_VisibleInput)
            gui_VisibleInput = get(gui_hFigure,'Visible');
        end
        set(gui_hFigure,'Visible','off')

        % openfig (called by local_openfig below) does this for guis without
        % the LayoutFcn. Be sure to do it here so guis show up on screen.
        movegui(gui_hFigure,'onscreen');
    else
        gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt, gui_Visible);
        % If the figure has InGUIInitialization it was not completely created
        % on the last pass.  Delete this handle and try again.
        if isappdata(gui_hFigure, 'InGUIInitialization')
            delete(gui_hFigure);
            gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt, gui_Visible);
        end
    end
    if isappdata(0, genvarname(['OpenGuiWhenRunning_', gui_State.gui_Name]))
        rmappdata(0,genvarname(['OpenGuiWhenRunning_', gui_State.gui_Name]));
    end

    % Set flag to indicate starting GUI initialization
    setappdata(gui_hFigure,'InGUIInitialization',1);

    % Fetch GUIDE Application options
    gui_Options = getappdata(gui_hFigure,'GUIDEOptions');
    % Singleton setting in the GUI M-file takes priority if different
    gui_Options.singleton = gui_State.gui_Singleton;

    if ~isappdata(gui_hFigure,'GUIOnScreen')
        % Adjust background color
        if gui_Options.syscolorfig
            set(gui_hFigure,'Color', get(0,'DefaultUicontrolBackgroundColor'));
        end

        % Generate HANDLES structure and store with GUIDATA. If there is
        % user set GUI data already, keep that also.
        data = guidata(gui_hFigure);
        handles = guihandles(gui_hFigure);
        if ~isempty(handles)
            if isempty(data)
                data = handles;
            else
                names = fieldnames(handles);
                for k=1:length(names)
                    data.(char(names(k)))=handles.(char(names(k)));
                end
            end
        end
        guidata(gui_hFigure, data);
    end

    % Apply input P/V pairs other than 'visible'
    for index=1:2:length(varargin)
        if length(varargin) == index || ~ischar(varargin{index})
            break;
        end

        len1 = min(length('visible'),length(varargin{index}));
        if ~strncmpi(varargin{index},'visible',len1)
            try set(gui_hFigure, varargin{index}, varargin{index+1}), catch break, end %#ok<SEPEX,CTCH>
        end
    end

    % If handle visibility is set to 'callback', turn it on until finished
    % with OpeningFcn
    gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
    if strcmp(gui_HandleVisibility, 'callback')
        set(gui_hFigure,'HandleVisibility', 'on');
    end

    feval(gui_State.gui_OpeningFcn, gui_hFigure, [], guidata(gui_hFigure), varargin{:});

    if isscalar(gui_hFigure) && ishandle(gui_hFigure)
        % Handle the default callbacks of predefined toolbar tools in this
        % GUI, if any
%         guidemfile('restoreToolbarToolPredefinedCallback',gui_hFigure); 
        
        % Update handle visibility
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);

        % Call openfig again to pick up the saved visibility or apply the
        % one passed in from the P/V pairs
        if ~gui_Exported
            gui_hFigure = local_openfig(gui_State.gui_Name, 'reuse',gui_Visible);
        elseif ~isempty(gui_VisibleInput)
            set(gui_hFigure,'Visible',gui_VisibleInput);
        end
        if strcmpi(get(gui_hFigure, 'Visible'), 'on')
            figure(gui_hFigure);
            
            if gui_Options.singleton
                setappdata(gui_hFigure,'GUIOnScreen', 1);
            end
        end

        % Done with GUI initialization
        if isappdata(gui_hFigure,'InGUIInitialization')
            rmappdata(gui_hFigure,'InGUIInitialization');
        end

        % If handle visibility is set to 'callback', turn it on until
        % finished with OutputFcn
        gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
        if strcmp(gui_HandleVisibility, 'callback')
            set(gui_hFigure,'HandleVisibility', 'on');
        end
        gui_Handles = guidata(gui_hFigure);
    else
        gui_Handles = [];
    end

    if nargout
        [varargout{1:nargout}] = feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    else
        feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    end

    if isscalar(gui_hFigure) && ishandle(gui_hFigure)
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
    end
end

function gui_hFigure = local_openfig(name, singleton, visible)

% openfig with three arguments was new from R13. Try to call that first, if
% failed, try the old openfig.
if nargin('openfig') == 2
    % OPENFIG did not accept 3rd input argument until R13,
    % toggle default figure visible to prevent the figure
    % from showing up too soon.
    gui_OldDefaultVisible = get(0,'defaultFigureVisible');
    set(0,'defaultFigureVisible','off');
    gui_hFigure = openfig(name, singleton);
    set(0,'defaultFigureVisible',gui_OldDefaultVisible);
else
    gui_hFigure = openfig(name, singleton, visible);
end

function result = local_isInvokeActiveXCallback(gui_State, varargin) %#ok<INUSL>

try
    result = ispc && iscom(varargin{1}) ...
             && isequal(varargin{1},gcbo);
catch %#ok<CTCH>
    result = false;
end

function result = local_isInvokeHGCallbak(gui_State, varargin)

try
    fhandle = functions(gui_State.gui_Callback);
    result = ~isempty(strfind(gui_State.gui_Name,fhandle.file)) || ...
             (ischar(varargin{1}) ...
             && isequal(ishandle(varargin{2}), 1) ...
             && (~isempty(strfind(varargin{1},[get(varargin{2}, 'Tag'), '_'])) || ...
                ~isempty(strfind(varargin{1}, '_CreateFcn'))) );
catch %#ok<CTCH>
    result = false;
end

% [EOF]
